enum {
   TIMERCOUNT  = 0x9000 ,
   TIMERRELOAD = 0x9001 ,
   TIMERREPEAT = 0x9002 ,

   UARTBRR     = 0xA002
} ;

void printc ( char c ) `1 ( 0xA000 @ ) 0xA000 !`
void printd ( char d ) `0x0F & # 10 < { '0' ~ '7' } + printc`
void printb ( char b ) `# 4 >> printd printd`
void printn ( int n ) `# 8 >> printb printb`
void prints ( char * s ) `# @ ( # @ printc 1 + # @ ) _`

extern int va_count ( ) ;
extern int va_arg ( int n ) ;

void printf ( char * fmt , ... ) {
   char * p = fmt ;
   int n = 0 ;
   char c ;
   while ( c = * p ++ ) {
      if ( c == '%' ) {
         switch ( c = * p ++ ) {
            case 'c' : printc ( va_arg ( n ++ ) ) ; break ;
            case 'X' : printn ( va_arg ( n ++ ) ) ; break ;
            case 's' : prints ( va_arg ( n ++ ) ) ; break ;
            case 'n' : printc ( 10 ) ; break ;
            default  : printc ( c ) ;
         }
      }
      else printc ( c ) ;
   }
}

extern int strcmp ( char * s1 , char * s2 ) ;
extern char * strcpy ( char * d , char * s ) ;

enum { NUMBER_OF_RUNS = 256 } ;

typedef enum { Ident_1 , Ident_2 , Ident_3 , Ident_4 , Ident_5 } Enumeration ;

typedef long intptr_t ;

enum { Null = 0 } ;
enum { true = 1 } ;
enum { false = 0 } ;

typedef int     One_Thirty ;
typedef int     One_Fifty ;
typedef char    Capital_Letter ;
typedef int     Boolean ;
typedef char    Str_30 [ 31 ] ;
typedef int     Arr_1_Dim [ 50 ] ;
typedef int     Arr_2_Dim [ 50 ] [ 50 ] ;

typedef struct record
    {
    struct record * Ptr_Comp ;
    Enumeration    Discr ;
    union {
          struct {
                  Enumeration Enum_Comp ;
                  int         Int_Comp ;
                  char        Str_Comp [ 31 ] ;
                  } var_1 ;
          struct {
                  Enumeration E_Comp_2 ;
                  char        Str_2_Comp [ 31 ] ;
                  } var_2 ;
          struct {
                  char        Ch_1_Comp ;
                  char        Ch_2_Comp ;
                  } var_3 ;
          } variant ;
      } Rec_Type , * Rec_Pointer ;

void Proc_1 ( Rec_Pointer Ptr_Val_Par ) ;
void Proc_2 ( One_Fifty * Int_Par_Ref ) ;
void Proc_3 ( Rec_Pointer * Ptr_Ref_Par ) ;
void Proc_4 ( ) ;
void Proc_5 ( ) ;
void Proc_6 ( Enumeration Enum_Val_Par , Enumeration * Enum_Ref_Par ) ;
void Proc_7 ( One_Fifty Int_1_Par_Val , One_Fifty Int_2_Par_Val , One_Fifty * Int_Par_Ref ) ;
void Proc_8 ( Arr_1_Dim Arr_1_Par_Ref , Arr_2_Dim Arr_2_Par_Ref , int Int_1_Par_Val , int Int_2_Par_Val ) ;

Enumeration Func_1 ( Capital_Letter Ch_1_Par_Val , Capital_Letter Ch_2_Par_Val ) ;
Boolean Func_2 ( Str_30 Str_1_Par_Ref , Str_30 Str_2_Par_Ref ) ;
Boolean Func_3 ( Enumeration Enum_Par_Val ) ;

Rec_Pointer     Ptr_Glob ,
                Next_Ptr_Glob ;
int             Int_Glob ;
Boolean         Bool_Glob ;
char            Ch_1_Glob ,
                Ch_2_Glob ;
int             Arr_1_Glob [ 50 ] ;
int             Arr_2_Glob [ 50 ] [ 50 ] ;

Boolean         Done ;

long            Begin_Time ,
                End_Time ,
                User_Time ;
float           Microseconds ,
                Dhrystones_Per_Second ;

Rec_Type R0 , R1 ;

void Proc_1 ( Rec_Pointer Ptr_Val_Par ) {
      Rec_Pointer Next_Record = Ptr_Val_Par -> Ptr_Comp ;

  * Ptr_Val_Par -> Ptr_Comp = * Ptr_Glob ;
  Ptr_Val_Par -> variant . var_1 . Int_Comp = 5 ;
  Next_Record -> variant . var_1 . Int_Comp
        = Ptr_Val_Par -> variant . var_1 . Int_Comp ;
  Next_Record -> Ptr_Comp = Ptr_Val_Par -> Ptr_Comp ;
  Proc_3 ( & Next_Record -> Ptr_Comp ) ;
  if ( Next_Record -> Discr == Ident_1 )
  {
    Next_Record -> variant . var_1 . Int_Comp = 6 ;
    Proc_6 ( Ptr_Val_Par -> variant . var_1 . Enum_Comp ,
           & Next_Record -> variant . var_1 . Enum_Comp ) ;
    Next_Record -> Ptr_Comp = Ptr_Glob -> Ptr_Comp ;
    Proc_7 ( Next_Record -> variant . var_1 . Int_Comp , 10 ,
           & Next_Record -> variant . var_1 . Int_Comp ) ;
  }
  else
    * Ptr_Val_Par = * Ptr_Val_Par -> Ptr_Comp ;
}


void Proc_2 ( One_Fifty * Int_Par_Ref )
{
  One_Fifty  Int_Loc ;
  Enumeration   Enum_Loc ;

  Int_Loc = * Int_Par_Ref + 10 ;
  do
    if ( Ch_1_Glob == 'A' )
    {
      Int_Loc -= 1 ;
      * Int_Par_Ref = Int_Loc - Int_Glob ;
      Enum_Loc = Ident_1 ;
    }
  while ( Enum_Loc != Ident_1 ) ;
}


void Proc_3 ( Rec_Pointer * Ptr_Ref_Par )
{
  if ( Ptr_Glob != Null )
    * Ptr_Ref_Par = Ptr_Glob -> Ptr_Comp ;
  Proc_7 ( 10 , Int_Glob , & Ptr_Glob -> variant . var_1 . Int_Comp ) ;
}


void Proc_4 ( )
{
  Boolean Bool_Loc ;

  Bool_Loc = Ch_1_Glob == 'A' ;
  Bool_Glob = Bool_Loc | Bool_Glob ;
  Ch_2_Glob = 'B' ;
}


void Proc_5 ( )
{
  Ch_1_Glob = 'A' ;
  Bool_Glob = false ;
}

void Proc_6 ( Enumeration Enum_Val_Par , Enumeration * Enum_Ref_Par )
{
  * Enum_Ref_Par = Enum_Val_Par ;
  if ( ! Func_3 ( Enum_Val_Par ) )
    * Enum_Ref_Par = Ident_4 ;
  switch ( Enum_Val_Par )
  {
    case Ident_1 :
      * Enum_Ref_Par = Ident_1 ;
      break ;
    case Ident_2 :
      if ( Int_Glob > 100 )
      * Enum_Ref_Par = Ident_1 ;
      else * Enum_Ref_Par = Ident_4 ;
      break ;
    case Ident_3 :
      * Enum_Ref_Par = Ident_2 ;
      break ;
    case Ident_4 : break ;
    case Ident_5 :
      * Enum_Ref_Par = Ident_3 ;
      break ;
  }
}

void Proc_7 ( One_Fifty Int_1_Par_Val , One_Fifty Int_2_Par_Val , One_Fifty * Int_Par_Ref )
{
  One_Fifty Int_Loc ;

  Int_Loc = Int_1_Par_Val + 2 ;
  * Int_Par_Ref = Int_2_Par_Val + Int_Loc ;
}


void Proc_8 ( Arr_1_Dim Arr_1_Par_Ref , Arr_2_Dim Arr_2_Par_Ref , int Int_1_Par_Val , int Int_2_Par_Val )
{
      One_Fifty Int_Index ;
      One_Fifty Int_Loc ;

  Int_Loc = Int_1_Par_Val + 5 ;
  Arr_1_Par_Ref [ Int_Loc ] = Int_2_Par_Val ;
  Arr_1_Par_Ref [ Int_Loc + 1 ] = Arr_1_Par_Ref [ Int_Loc ] ;
  Arr_1_Par_Ref [ Int_Loc + 30 ] = Int_Loc ;
  for ( Int_Index = Int_Loc ; Int_Index <= Int_Loc + 1 ; ++ Int_Index )
    Arr_2_Par_Ref [ Int_Loc ] [ Int_Index ] = Int_Loc ;
  Arr_2_Par_Ref [ Int_Loc ] [ Int_Loc - 1 ] += 1 ;
  Arr_2_Par_Ref [ Int_Loc + 20 ] [ Int_Loc ] = Arr_1_Par_Ref [ Int_Loc ] ;
  Int_Glob = 5 ;
}


Enumeration Func_1 ( Capital_Letter Ch_1_Par_Val , Capital_Letter Ch_2_Par_Val )
{
  Capital_Letter        Ch_1_Loc ;
  Capital_Letter        Ch_2_Loc ;

  Ch_1_Loc = Ch_1_Par_Val ;
  Ch_2_Loc = Ch_1_Loc ;
  if ( Ch_2_Loc != Ch_2_Par_Val )
    return ( Ident_1 ) ;
  else
  {
    Ch_1_Glob = Ch_1_Loc ;
    return ( Ident_2 ) ;
  }
}


Boolean Func_2 ( Str_30 Str_1_Par_Ref , Str_30 Str_2_Par_Ref )
{
      One_Thirty        Int_Loc ;
      Capital_Letter    Ch_Loc ;

  Int_Loc = 2 ;
  while ( Int_Loc <= 2 )
    if ( Func_1 ( Str_1_Par_Ref [ Int_Loc ] ,
                Str_2_Par_Ref [ Int_Loc + 1 ] ) == Ident_1 )
    {
      Ch_Loc = 'A' ;
      Int_Loc += 1 ;
    }
  if ( Ch_Loc >= 'W' && Ch_Loc < 'Z' )
    Int_Loc = 7 ;
  if ( Ch_Loc == 'R' )
    return ( true ) ;
  else
  {
    if ( strcmp ( Str_1_Par_Ref , Str_2_Par_Ref ) > 0 )
    {
      Int_Loc += 7 ;
      Int_Glob = Int_Loc ;
      return ( true ) ;
    }
    else
      return ( false ) ;
  }
}

Boolean Func_3 ( Enumeration Enum_Par_Val )
{
  Enumeration Enum_Loc ;

  Enum_Loc = Enum_Par_Val ;
  if ( Enum_Loc == Ident_3 )
    return ( true ) ;
  else
    return ( false ) ;
}

void main ( ) {
   * ( int * ) UARTBRR = 173 ;
   * ( int * ) TIMERRELOAD = 20000 ;

        One_Fifty       Int_1_Loc ;
        One_Fifty       Int_2_Loc ;
        One_Fifty       Int_3_Loc ;
        char            Ch_Index ;
        Enumeration     Enum_Loc ;
        Str_30          Str_1_Loc ;
        Str_30          Str_2_Loc ;
        int             Run_Index ;
        int             Number_Of_Runs ;

  Number_Of_Runs = NUMBER_OF_RUNS ;

  Next_Ptr_Glob = & R0 ;
  Ptr_Glob = & R1 ;

  Ptr_Glob -> Ptr_Comp                    = Next_Ptr_Glob ;
  Ptr_Glob -> Discr                       = Ident_1 ;
  Ptr_Glob -> variant . var_1 . Enum_Comp     = Ident_3 ;
  Ptr_Glob -> variant . var_1 . Int_Comp      = 40 ;
  strcpy ( Ptr_Glob -> variant . var_1 . Str_Comp , "DHRYSTONE PROGRAM, SOME STRING" ) ;
  strcpy ( Str_1_Loc , "DHRYSTONE PROGRAM, 1'ST STRING" ) ;

  Arr_2_Glob [ 8 ] [ 7 ] = 10 ;

  printf ( "%nDhrystone Benchmark, Version C, Version 2.2a%n" ) ;
  printf ( "Program compiled without 'register' attribute%n" ) ;
  printf ( "Using clock(), HZ=1000%n%n" ) ;

  Done = false ;
  while ( ! Done ) {

    printf ( "Trying 0x%X runs: " , Number_Of_Runs ) ;

    * ( int * ) TIMERREPEAT = 0xFFFF ;
    Begin_Time = * ( int * ) TIMERREPEAT ;

    for ( Run_Index = 1 ; Run_Index <= Number_Of_Runs ; ++ Run_Index )
    {

      Proc_5 ( ) ;
      Proc_4 ( ) ;
      Int_1_Loc = 2 ;
      Int_2_Loc = 3 ;
      strcpy ( Str_2_Loc , "DHRYSTONE PROGRAM, 2'ND STRING" ) ;
      Enum_Loc = Ident_2 ;
      Bool_Glob = ! Func_2 ( Str_1_Loc , Str_2_Loc ) ;
      while ( Int_1_Loc < Int_2_Loc )
      {
        Int_3_Loc = 5 * Int_1_Loc - Int_2_Loc ;
        Proc_7 ( Int_1_Loc , Int_2_Loc , & Int_3_Loc ) ;
        Int_1_Loc += 1 ;
      }
      Proc_8 ( Arr_1_Glob , Arr_2_Glob , Int_1_Loc , Int_3_Loc ) ;
      Proc_1 ( Ptr_Glob ) ;
      for ( Ch_Index = 'A' ; Ch_Index <= Ch_2_Glob ; ++ Ch_Index )
      {
        if ( Enum_Loc == Func_1 ( Ch_Index , 'C' ) )
          {
          Proc_6 ( Ident_1 , & Enum_Loc ) ;
          strcpy ( Str_2_Loc , "DHRYSTONE PROGRAM, 3'RD STRING" ) ;
          Int_2_Loc = Run_Index ;
          Int_Glob = Run_Index ;
          }
      }
      Int_2_Loc = Int_2_Loc * Int_1_Loc ;
      Int_1_Loc = Int_2_Loc / Int_3_Loc ;
      Int_2_Loc = 7 * ( Int_2_Loc - Int_3_Loc ) - Int_1_Loc ;
      Proc_2 ( & Int_1_Loc ) ;
    }

    End_Time = * ( int * ) TIMERREPEAT ;

    User_Time = Begin_Time - End_Time ;

    Done = true ;
  }

  printf ( "Final values of the variables used in the benchmark:%n%n" ) ;
  printf ( "Int_Glob:         0x%X/0x%X%n" , Int_Glob , 5 ) ;
  printf ( "Bool_Glob:        0x%X/0x%X%n" , Bool_Glob , 1 ) ;
  printf ( "Ch_1_Glob:        %c/%c%n" , Ch_1_Glob , 'A' ) ;
  printf ( "Ch_2_Glob:        %c/%c%n" , Ch_2_Glob , 'B' ) ;
  printf ( "Arr_1_Glob[8]:    0x%X/0x%X%n" , Arr_1_Glob [ 8 ] , 7 ) ;
  printf ( "Arr_2_Glob[8][7]: 0x%X/%s%n" , Arr_2_Glob [ 8 ] [ 7 ] , "Number_Of_Runs + 10") ;
  printf ( "Ptr_Glob->%n" ) ;
  printf ( "  Ptr_Comp:       0x%X/%s%n" , ( intptr_t ) Ptr_Glob -> Ptr_Comp , "(implementation-dependent)" ) ;
  printf ( "  Discr:          0x%X/0x%X%n" , Ptr_Glob -> Discr , 0 ) ;
  printf ( "  Enum_Comp:      0x%X/0x%X%n" , Ptr_Glob -> variant . var_1 . Enum_Comp , 2 ) ;
  printf ( "  Int_Comp:       0x%X/0x%X%n" , Ptr_Glob -> variant . var_1 . Int_Comp , 17 ) ;
  printf ( "  Str_Comp:       %s/%s%n" , Ptr_Glob -> variant . var_1 . Str_Comp , "DHRYSTONE PROGRAM, SOME STRING" ) ;
  printf ( "Next_Ptr_Glob->%n") ;
  printf ( "  Ptr_Comp:       0x%X/%s%n" , ( intptr_t ) Next_Ptr_Glob -> Ptr_Comp , "(implementation-dependent), same as above" ) ;
  printf ( "  Discr:          0x%X/0x%X%n" , Next_Ptr_Glob -> Discr , 0 ) ;
  printf ( "  Enum_Comp:      0x%X/0x%X%n" , Next_Ptr_Glob -> variant . var_1 . Enum_Comp , 1 ) ;
  printf ( "  Int_Comp:       0x%X/0x%X%n" , Next_Ptr_Glob -> variant . var_1 . Int_Comp , 18 ) ;
  printf ( "  Str_Comp:       %s/%s%n" , Next_Ptr_Glob -> variant . var_1 . Str_Comp , "DHRYSTONE PROGRAM, SOME STRING" ) ;
  printf ( "Int_1_Loc:        0x%X/0x%X%n" , Int_1_Loc , 5 ) ;
  printf ( "Int_2_Loc:        0x%X/0x%X%n" , Int_2_Loc , 13 ) ;
  printf ( "Int_3_Loc:        0x%X/0x%X%n" , Int_3_Loc , 7 ) ;
  printf ( "Enum_Loc:         0x%X/0x%X%n" , Enum_Loc , 1 ) ;
  printf ( "Str_1_Loc:        %s/%s%n" , Str_1_Loc , "DHRYSTONE PROGRAM, 1'ST STRING" ) ;
  printf ( "Str_2_Loc:        %s/%s%n" , Str_2_Loc , "DHRYSTONE PROGRAM, 2'ND STRING" ) ;

    printf ( "%n%nTime: 0x%Xms" , User_Time ) ;
    printf ( "%nDhrystones: 0x%X" , Number_Of_Runs ) ;
    printf ( "%nDhrystones per Second: 0x%XK" , Number_Of_Runs / User_Time ) ;

  while ( 1 ) ;
}
