enum {
   GPIO        = 0x8000,

   TIMERCOUNT  = 0x9000,
   TIMERRELOAD = 0x9001,
   TIMERREPEAT = 0x9002,

   UARTTX      = 0xA000,
   UARTRX      = 0xA001,
   UARTBRR     = 0xA002
} ;

void delay (int ms) {
   *(int*)TIMERREPEAT = ms ;
   while (*(int*)TIMERREPEAT);
}

void printc (char c) {
   while (*(char*)UARTTX);
   *(char*)UARTTX = c;
}

void printn (int n) {
   printc(n/10 + '0');
   printc(n%10 + '0');
}

int hour = 12, min = 34, sec = 56;

void printtime () {
   printn(hour);
   printc(':');
   printn(min);
   printc(':');
   printn(sec);
   printc(0x0A);
}

void main () {
   *(int*)UARTBRR = 173;
   *(int*)TIMERRELOAD = 20000;
   while (1) {
      *(int*)GPIO = (sec&1) | ((min&1)<<1) | ((hour&1)<<2) | 0b111000;
      printtime();
      if ((!(sec = (sec+1) % 60)) &&
          (!(min = (min+1) % 60))) hour = (hour+1) % 24;
      delay(1000);
   }
}