`timescale 1 ns / 1 ps
`define PUSH   2
`define JZ     3
`define LOAD   4
`define STORE  5
`define NAND   6
`define SUB    7

`define DEPTH 16

module core16 (
   input  wire r,
   input  wire c,
   output wire [15:0] a,
   input  wire [15:0] i,
   output wire [15:0] o,
   output wire w
);

reg [15:0] data [0:8191];
reg [15:0] code [0:16383];
reg [15:0] pc;
reg [15:0] npc;
reg [2:0] cmd;
reg [15:0] v;

reg [15:0] ds [0:`DEPTH-1];
reg [15:0] sp = 0;
reg [15:0] nsp;

reg  [15:0] s0 = 0;
wire [15:0] s1 = ds[sp-1];
wire [15:0] s2 = ds[sp-2];

wire mmr = s0[15];

always @* npc <= (cmd==`JZ)?s1?pc+1:s0:pc+1;

always @* case (cmd)
   `PUSH   : nsp <= sp+1;
   `JZ     : nsp <= sp-2;
   `LOAD   : nsp <= sp;
   `STORE  : nsp <= sp-2;
   `NAND   : nsp <= sp-1;
   `SUB    : nsp <= sp-1;
   default : nsp <= sp;
endcase

always @ (negedge c) case (cmd)
   `PUSH   : begin s0 <= 0; ds[nsp-1] <= s0; end
   `JZ     : s0 <= s2;
   `LOAD   : s0 <= mmr?i:v;
   `STORE  : s0 <= s2;
   `NAND   : s0 <= ~(s1&s0);
   `SUB    : s0 <= s1-s0;
   default : s0 <= {s0[14:0],cmd[0:0]};
endcase

assign a = s0;
assign o = s1;
assign w = (cmd==`STORE);

always @ (negedge c) begin
   cmd <= r?0:code[npc>>2]>>((npc&3)*4);
   pc <= r?-1:npc;
   sp <= nsp;
end

always @ (posedge c) begin
   if (w & ~mmr) data [a] <= o;
   v <= data [a];
end

always @ (posedge r) begin
`include "firmware.vx"
end

endmodule