`timescale 1ns/1ps

module mcu16(
   input clk,
   input rx, output tx,
   output [7:0] led
);

wire l,c,r,w;
wire [15:0] a,e,d0,d8,d9,dA,dB,dC,dD,dE,dF;

assign r = ~l;

pll     CLK   (.clkin(clk),.clkout(),.clkoutd(),.clkoutd3(c),.lock(l));

core16  CORE  (.c(c),.r(r),.w(w),.a(a),          .i(dA),.o(d0));
sel     SEL   (.c( ),.r( ),      .a(a),.e(e));
gpio    GPIO  (.c(c),.r( ),.w(w),.a(a),.e(e[ 8]),.i(d0),.o(d8),.p(led));
timer   TIMER (.c(c),.r( ),.w(w),.a(a),.e(e[ 9]),.i(d8),.o(d9));
uart    UART  (.c(c),.r( ),.w(w),.a(a),.e(e[10]),.i(d9),.o(dA),.tx(tx),.rx(rx));

endmodule

