`timescale 1 ns / 1 ps
module uart (
   input  wire r,
   input  wire c,
   output wire tx,
   input  wire rx,
   input  wire [15:0] a,
   input  wire [15:0] i,
   output wire [15:0] o,
   input  wire w,
   input  wire e
);
reg [15:0] data [0:2];
reg [15:0] tcount = 0;
reg  [9:0] tdata = 10'b1111111111;
reg [15:0] rcount;
reg  [7:0] rdata;
reg  [4:0] rphase;
wire [1:0] addr = a[1:0];
always @ (posedge c) begin
   if (w&e) begin
      if (addr) data[addr] <= i; else begin tdata <= {i[7:0],2'b01}; data[0] <= 1; end
   end else begin
      if (!tcount) begin tdata <= {1'b1,tdata[9:1]}; data[0] <= data[0][8:0]<<1; end
      if (!rcount) begin
         if (rphase == 1) data[1] <= rdata;
         if (rphase[4:2] && !rphase[0]) rdata <= (rx<<7) | (rdata>>1);
         if (rphase) rphase <= rphase-1; else if (~rx) rphase <= 19;
      end
   end
   rcount <= rcount?rcount-1:(data[2]>>1);
   tcount <= tcount?tcount-1:data[2];
end
assign o = e ? data[addr] : i;
assign tx = tdata[0];
endmodule